ALTER TABLE PSIM.IMDQ_TASK_H
  DROP CONSTRAINT AVCON_1172516538_TRANS_000;

ALTER TABLE PSIM.IMDQ_TASK_H ADD (
  CONSTRAINT AVCON_1172516538_TRANS_000
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_MESSAGE_LOG
  DROP CONSTRAINT AVCON_1179948058_MESSA_000;

ALTER TABLE PSIM.PS_MESSAGE_LOG ADD (
  CONSTRAINT AVCON_1179948058_MESSA_000
  CHECK (MESSAGE_DIRECTION_CODE IN ('O', 'I'))
  ENABLE VALIDATE);
ALTER TABLE PSIM.EVENT
  DROP CONSTRAINT EVT_PK;

ALTER TABLE PSIM.EVENT ADD (
  CONSTRAINT EVT_PK
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.EVENT
  DROP CONSTRAINT EVT_QUE_FK;


ALTER TABLE PSIM.EVENT ADD (
  CONSTRAINT EVT_QUE_FK 
  FOREIGN KEY (QUEUE_ID) 
  REFERENCES PSIM.QUEUE (ID)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT
  DROP CONSTRAINT IDMEXNTRT_PK;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT ADD (
  CONSTRAINT IDMEXNTRT_PK
  PRIMARY KEY
  (IMDQ_EXCEPTION_TRAIT_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IDM_MESSAGE_LOG
  DROP CONSTRAINT IDMMLOG_AVCON_MESSA_20;

ALTER TABLE PSIM.IDM_MESSAGE_LOG ADD (
  CONSTRAINT IDMMLOG_AVCON_MESSA_20
  CHECK (MESSAGE_DIRECTION_CODE IN ('O', 'I'))
  ENABLE VALIDATE);
ALTER TABLE PSIM.IDM_MESSAGE_LOG
  DROP CONSTRAINT IDMMLOG_PSPERCOR_20_FK;


ALTER TABLE PSIM.IDM_MESSAGE_LOG ADD (
  CONSTRAINT IDMMLOG_PSPERCOR_20_FK 
  FOREIGN KEY (PERSON_CORRELATION_ID) 
  REFERENCES PSIM.PS_PERSON_CORRELATION (PS_PERSON_CORRELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP
  DROP CONSTRAINT IDMNTFGRP_PK;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP ADD (
  CONSTRAINT IDMNTFGRP_PK
  PRIMARY KEY
  (IDM_NOTIFICATION_GROUP_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IDM_NOTIFICATION
  DROP CONSTRAINT IDMNTF_PK;

ALTER TABLE PSIM.IDM_NOTIFICATION ADD (
  CONSTRAINT IDMNTF_PK
  PRIMARY KEY
  (IDM_NOTIFICATION_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IDM_NOTE_REF
  DROP CONSTRAINT IDMNT_PK;

ALTER TABLE PSIM.IDM_NOTE_REF ADD (
  CONSTRAINT IDMNT_PK
  PRIMARY KEY
  (IDM_NOTE_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IDM_STATION_MAP
  DROP CONSTRAINT IDMSTMP_PK;

ALTER TABLE PSIM.IDM_STATION_MAP ADD (
  CONSTRAINT IDMSTMP_PK
  PRIMARY KEY
  (IDM_STATION_MAP_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_ACTION_REF
  DROP CONSTRAINT IMDQATNREF_PK;

ALTER TABLE PSIM.IMDQ_ACTION_REF ADD (
  CONSTRAINT IMDQATNREF_PK
  PRIMARY KEY
  (IMDQ_ACTION_REF_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_ACTION
  DROP CONSTRAINT IMDQATN_IMDQATNREF_FK;


ALTER TABLE PSIM.IMDQ_ACTION ADD (
  CONSTRAINT IMDQATN_IMDQATNREF_FK 
  FOREIGN KEY (IMDQ_ACTION_REF_ID) 
  REFERENCES PSIM.IMDQ_ACTION_REF (IMDQ_ACTION_REF_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_ACTION
  DROP CONSTRAINT IMDQATN_IMDQEXNIDS_FK;


ALTER TABLE PSIM.IMDQ_ACTION ADD (
  CONSTRAINT IMDQATN_IMDQEXNIDS_FK 
  FOREIGN KEY (IMDQ_EXCEPTION_IDS_ID2) 
  REFERENCES PSIM.IMDQ_EXCEPTION_IDS (IMDQ_EXCEPTION_IDS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_ACTION
  DROP CONSTRAINT IMDQATN_IMDQEXNIDS_HAVE1_FK;


ALTER TABLE PSIM.IMDQ_ACTION ADD (
  CONSTRAINT IMDQATN_IMDQEXNIDS_HAVE1_FK 
  FOREIGN KEY (IMDQ_EXCEPTION_IDS_ID1) 
  REFERENCES PSIM.IMDQ_EXCEPTION_IDS (IMDQ_EXCEPTION_IDS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_ACTION
  DROP CONSTRAINT IMDQATN_IMDQEXPN_FK;


ALTER TABLE PSIM.IMDQ_ACTION ADD (
  CONSTRAINT IMDQATN_IMDQEXPN_FK 
  FOREIGN KEY (IMDQ_EXCEPTION_ID) 
  REFERENCES PSIM.IMDQ_EXCEPTION (IMDQ_EXCEPTION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_ACTION
  DROP CONSTRAINT IMDQATN_IMDQTMMBR_FK;


ALTER TABLE PSIM.IMDQ_ACTION ADD (
  CONSTRAINT IMDQATN_IMDQTMMBR_FK 
  FOREIGN KEY (IMDQ_TEAM_MEMBER_ID) 
  REFERENCES PSIM.IMDQ_TEAM_MEMBER (IMDQ_TEAM_MEMBER_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_ACTION
  DROP CONSTRAINT IMDQATN_PK;

ALTER TABLE PSIM.IMDQ_ACTION ADD (
  CONSTRAINT IMDQATN_PK
  PRIMARY KEY
  (IMDQ_ACTION_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS
  DROP CONSTRAINT IMDQEXNIDS_IMDQEXPN_FK;


ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS ADD (
  CONSTRAINT IMDQEXNIDS_IMDQEXPN_FK 
  FOREIGN KEY (IMDQ_EXCEPTION_ID) 
  REFERENCES PSIM.IMDQ_EXCEPTION (IMDQ_EXCEPTION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS
  DROP CONSTRAINT IMDQEXNIDS_PK;

ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS ADD (
  CONSTRAINT IMDQEXNIDS_PK
  PRIMARY KEY
  (IMDQ_EXCEPTION_IDS_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE
  DROP CONSTRAINT IMDQEXPNTY_PK;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE ADD (
  CONSTRAINT IMDQEXPNTY_PK
  PRIMARY KEY
  (IMDQ_EXCEPTION_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_EXCEPTION
  DROP CONSTRAINT IMDQEXPN_IMDQEXPNTY_FK;


ALTER TABLE PSIM.IMDQ_EXCEPTION ADD (
  CONSTRAINT IMDQEXPN_IMDQEXPNTY_FK 
  FOREIGN KEY (IMDQ_EXCEPTION_TYPE_ID) 
  REFERENCES PSIM.IMDQ_EXCEPTION_TYPE (IMDQ_EXCEPTION_TYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_EXCEPTION
  DROP CONSTRAINT IMDQEXPN_PK;

ALTER TABLE PSIM.IMDQ_EXCEPTION ADD (
  CONSTRAINT IMDQEXPN_PK
  PRIMARY KEY
  (IMDQ_EXCEPTION_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_EXCEPTION
  DROP CONSTRAINT IMDQEXPN_PSSYSOFINT_FK;


ALTER TABLE PSIM.IMDQ_EXCEPTION ADD (
  CONSTRAINT IMDQEXPN_PSSYSOFINT_FK 
  FOREIGN KEY (PSSYSOFINT_ID) 
  REFERENCES PSIM.PS_SYSTEM_OF_INTEREST_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF
  DROP CONSTRAINT IMDQMRREF_IMDQROLE_FK;


ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF ADD (
  CONSTRAINT IMDQMRREF_IMDQROLE_FK 
  FOREIGN KEY (IMDQ_ROLE_ID) 
  REFERENCES PSIM.IMDQ_ROLE (IMDQ_ROLE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF
  DROP CONSTRAINT IMDQMRREF_IMDQTMMBR_FK;


ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF ADD (
  CONSTRAINT IMDQMRREF_IMDQTMMBR_FK 
  FOREIGN KEY (IMDQ_TEAM_MEMBER_ID) 
  REFERENCES PSIM.IMDQ_TEAM_MEMBER (IMDQ_TEAM_MEMBER_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF
  DROP CONSTRAINT IMDQMRREF_PK;

ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF ADD (
  CONSTRAINT IMDQMRREF_PK
  PRIMARY KEY
  (IMDQ_MEM_ROLE_REF_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_MEMBER_SITES
  DROP CONSTRAINT IMDQMS_IMDQATNREF_FK;


ALTER TABLE PSIM.IMDQ_MEMBER_SITES ADD (
  CONSTRAINT IMDQMS_IMDQATNREF_FK 
  FOREIGN KEY (ALLOWABLE_ACTION_ID) 
  REFERENCES PSIM.IMDQ_ACTION_REF (IMDQ_ACTION_REF_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_MEMBER_SITES
  DROP CONSTRAINT IMDQMS_IMDQTMMBR_FK;


ALTER TABLE PSIM.IMDQ_MEMBER_SITES ADD (
  CONSTRAINT IMDQMS_IMDQTMMBR_FK 
  FOREIGN KEY (IMDQ_TEAM_MEMBER_ID) 
  REFERENCES PSIM.IMDQ_TEAM_MEMBER (IMDQ_TEAM_MEMBER_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_MEMBER_SITES
  DROP CONSTRAINT IMDQMS_PK;

ALTER TABLE PSIM.IMDQ_MEMBER_SITES ADD (
  CONSTRAINT IMDQMS_PK
  PRIMARY KEY
  (IMDQ_MEMBER_SITES_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_ROLE
  DROP CONSTRAINT IMDQROLE_PK;

ALTER TABLE PSIM.IMDQ_ROLE ADD (
  CONSTRAINT IMDQROLE_PK
  PRIMARY KEY
  (IMDQ_ROLE_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK_H
  DROP CONSTRAINT IMDQTASKH_PK;

ALTER TABLE PSIM.IMDQ_TASK_H ADD (
  CONSTRAINT IMDQTASKH_PK
  PRIMARY KEY
  (IMDQ_TASK_H_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK
  DROP CONSTRAINT IMDQTASK_IMDQEXPN_FK;


ALTER TABLE PSIM.IMDQ_TASK ADD (
  CONSTRAINT IMDQTASK_IMDQEXPN_FK 
  FOREIGN KEY (IMDQ_EXCEPTION_ID) 
  REFERENCES PSIM.IMDQ_EXCEPTION (IMDQ_EXCEPTION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK
  DROP CONSTRAINT IMDQTASK_IMDQTMMBR_FK;


ALTER TABLE PSIM.IMDQ_TASK ADD (
  CONSTRAINT IMDQTASK_IMDQTMMBR_FK 
  FOREIGN KEY (IMDQ_TEAM_MEMBER_ASSGN_BY_ID) 
  REFERENCES PSIM.IMDQ_TEAM_MEMBER (IMDQ_TEAM_MEMBER_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK
  DROP CONSTRAINT IMDQTASK_IMDQTMMBR_HAVE1_FK;


ALTER TABLE PSIM.IMDQ_TASK ADD (
  CONSTRAINT IMDQTASK_IMDQTMMBR_HAVE1_FK 
  FOREIGN KEY (IMDQ_TEAM_MEMBER_ASSGN_TO_ID) 
  REFERENCES PSIM.IMDQ_TEAM_MEMBER (IMDQ_TEAM_MEMBER_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK
  DROP CONSTRAINT IMDQTASK_PK;

ALTER TABLE PSIM.IMDQ_TASK ADD (
  CONSTRAINT IMDQTASK_PK
  PRIMARY KEY
  (IMDQ_TASK_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TEAM_MEMBER
  DROP CONSTRAINT IMDQTMMBR_PK;

ALTER TABLE PSIM.IMDQ_TEAM_MEMBER ADD (
  CONSTRAINT IMDQTMMBR_PK
  PRIMARY KEY
  (IMDQ_TEAM_MEMBER_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK_NOTES
  DROP CONSTRAINT IMDQTSKNTS_IMDQTASK_FK;


ALTER TABLE PSIM.IMDQ_TASK_NOTES ADD (
  CONSTRAINT IMDQTSKNTS_IMDQTASK_FK 
  FOREIGN KEY (IMDQ_TASK_ID) 
  REFERENCES PSIM.IMDQ_TASK (IMDQ_TASK_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK_NOTES
  DROP CONSTRAINT IMDQTSKNTS_IMDQTMMBR_FK;


ALTER TABLE PSIM.IMDQ_TASK_NOTES ADD (
  CONSTRAINT IMDQTSKNTS_IMDQTMMBR_FK 
  FOREIGN KEY (IMDQ_TEAM_MEMBER_ID) 
  REFERENCES PSIM.IMDQ_TEAM_MEMBER (IMDQ_TEAM_MEMBER_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK_NOTES
  DROP CONSTRAINT IMDQTSKNTS_PK;

ALTER TABLE PSIM.IMDQ_TASK_NOTES ADD (
  CONSTRAINT IMDQTSKNTS_PK
  PRIMARY KEY
  (IMDQ_TASK_NOTES_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK_SOI
  DROP CONSTRAINT IMDQTSKSOI_IMDQTASK_FK;


ALTER TABLE PSIM.IMDQ_TASK_SOI ADD (
  CONSTRAINT IMDQTSKSOI_IMDQTASK_FK 
  FOREIGN KEY (IMDQ_TASK_ID) 
  REFERENCES PSIM.IMDQ_TASK (IMDQ_TASK_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK_SOI
  DROP CONSTRAINT IMDQTSKSOI_PK;

ALTER TABLE PSIM.IMDQ_TASK_SOI ADD (
  CONSTRAINT IMDQTSKSOI_PK
  PRIMARY KEY
  (IMDQ_TASK_SOI_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK_SOI
  DROP CONSTRAINT IMDQTSKSOI_PSSYSOFINT_FK;


ALTER TABLE PSIM.IMDQ_TASK_SOI ADD (
  CONSTRAINT IMDQTSKSOI_PSSYSOFINT_FK 
  FOREIGN KEY (PSSYSOFINT_ID) 
  REFERENCES PSIM.PS_SYSTEM_OF_INTEREST_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK_VPIDS
  DROP CONSTRAINT IMDQTSKVPD_IMDQTASK_FK;


ALTER TABLE PSIM.IMDQ_TASK_VPIDS ADD (
  CONSTRAINT IMDQTSKVPD_IMDQTASK_FK 
  FOREIGN KEY (IMDQ_TASK_ID) 
  REFERENCES PSIM.IMDQ_TASK (IMDQ_TASK_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_TASK_VPIDS
  DROP CONSTRAINT IMDQTSKVPD_PK;

ALTER TABLE PSIM.IMDQ_TASK_VPIDS ADD (
  CONSTRAINT IMDQTSKVPD_PK
  PRIMARY KEY
  (IMDQ_TASK_VPIDS_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_MESSAGE_LOG
  DROP CONSTRAINT MSGLOG_PK;

ALTER TABLE PSIM.PS_MESSAGE_LOG ADD (
  CONSTRAINT MSGLOG_PK
  PRIMARY KEY
  (PS_MESSAGE_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_MESSAGE_LOG
  DROP CONSTRAINT MSGLOG_PSPERCOR_FK;


ALTER TABLE PSIM.PS_MESSAGE_LOG ADD (
  CONSTRAINT MSGLOG_PSPERCOR_FK 
  FOREIGN KEY (PERSON_CORRELATION_ID) 
  REFERENCES PSIM.PS_PERSON_CORRELATION (PS_PERSON_CORRELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_ADT_EVENT
  DROP CONSTRAINT PSADTEVT_PK;

ALTER TABLE PSIM.PS_ADT_EVENT ADD (
  CONSTRAINT PSADTEVT_PK
  PRIMARY KEY
  (PS_ADT_EVENT_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_CHANGE_TYPE
  DROP CONSTRAINT PSCHGTYP_NAME_UK;

ALTER TABLE PSIM.PS_CHANGE_TYPE ADD (
  CONSTRAINT PSCHGTYP_NAME_UK
  UNIQUE (NAME)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_CHANGE_TYPE
  DROP CONSTRAINT PSCHGTYP_PK;

ALTER TABLE PSIM.PS_CHANGE_TYPE ADD (
  CONSTRAINT PSCHGTYP_PK
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_CORRELATION_CATEGORY
  DROP CONSTRAINT PSCORCAT_PK;

ALTER TABLE PSIM.PS_CORRELATION_CATEGORY ADD (
  CONSTRAINT PSCORCAT_PK
  PRIMARY KEY
  (PS_CORRELATION_CATEGORY_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_CORRELATION_CATEGORY
  DROP CONSTRAINT PSCORCAT_PSPERCOR_FK;


ALTER TABLE PSIM.PS_CORRELATION_CATEGORY ADD (
  CONSTRAINT PSCORCAT_PSPERCOR_FK 
  FOREIGN KEY (CORRELATION_ID) 
  REFERENCES PSIM.PS_PERSON_CORRELATION (PS_PERSON_CORRELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_DUPE_POTENTIAL
  DROP CONSTRAINT PSDUPPOT_PK;

ALTER TABLE PSIM.PS_DUPE_POTENTIAL ADD (
  CONSTRAINT PSDUPPOT_PK
  PRIMARY KEY
  (PS_DUPE_POTENTIAL_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_DUPE_POTENTIAL
  DROP CONSTRAINT PSDUPPOT_PSDUPREA_FK;


ALTER TABLE PSIM.PS_DUPE_POTENTIAL ADD (
  CONSTRAINT PSDUPPOT_PSDUPREA_FK 
  FOREIGN KEY (DUPE_REASON_ID) 
  REFERENCES PSIM.PS_DUPE_REASON_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_DUPE_POTENTIAL
  DROP CONSTRAINT PSDUPPOT_PSDUPRES_FK;


ALTER TABLE PSIM.PS_DUPE_POTENTIAL ADD (
  CONSTRAINT PSDUPPOT_PSDUPRES_FK 
  FOREIGN KEY (DUPE_RESOLUTION_ID) 
  REFERENCES PSIM.PS_DUPE_RESOLUTION_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_DUPE_POTENTIAL
  DROP CONSTRAINT PSDUPPOT_PSPERVPI1_FK;


ALTER TABLE PSIM.PS_DUPE_POTENTIAL ADD (
  CONSTRAINT PSDUPPOT_PSPERVPI1_FK 
  FOREIGN KEY (PERSON_VPID1_ID) 
  REFERENCES PSIM.PS_PERSON_VPID (PS_PERSONVPID_ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_DUPE_POTENTIAL
  DROP CONSTRAINT PSDUPPOT_PSPERVPI2_FK;


ALTER TABLE PSIM.PS_DUPE_POTENTIAL ADD (
  CONSTRAINT PSDUPPOT_PSPERVPI2_FK 
  FOREIGN KEY (PERSON_VPID2_ID) 
  REFERENCES PSIM.PS_PERSON_VPID (PS_PERSONVPID_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_DUPE_REASON_TYPE
  DROP CONSTRAINT PSDUPREA_NAME_UK;

ALTER TABLE PSIM.PS_DUPE_REASON_TYPE ADD (
  CONSTRAINT PSDUPREA_NAME_UK
  UNIQUE (NAME)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_DUPE_REASON_TYPE
  DROP CONSTRAINT PSDUPREA_PK;

ALTER TABLE PSIM.PS_DUPE_REASON_TYPE ADD (
  CONSTRAINT PSDUPREA_PK
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE
  DROP CONSTRAINT PSDUPRES_NAME_UK;

ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE ADD (
  CONSTRAINT PSDUPRES_NAME_UK
  UNIQUE (NAME)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE
  DROP CONSTRAINT PSDUPRES_PK;

ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE ADD (
  CONSTRAINT PSDUPRES_PK
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_EDIT_TYPE
  DROP CONSTRAINT PSEDITYP_NAME_UK;

ALTER TABLE PSIM.PS_EDIT_TYPE ADD (
  CONSTRAINT PSEDITYP_NAME_UK
  UNIQUE (NAME)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_EDIT_TYPE
  DROP CONSTRAINT PSEDITYP_PK;

ALTER TABLE PSIM.PS_EDIT_TYPE ADD (
  CONSTRAINT PSEDITYP_PK
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_EDIT
  DROP CONSTRAINT PSEDI_PK;

ALTER TABLE PSIM.PS_EDIT ADD (
  CONSTRAINT PSEDI_PK
  PRIMARY KEY
  (PS_EDIT_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_EDIT
  DROP CONSTRAINT PSEDI_PSEDITYP_FK;


ALTER TABLE PSIM.PS_EDIT ADD (
  CONSTRAINT PSEDI_PSEDITYP_FK 
  FOREIGN KEY (EDIT_TYPE_ID) 
  REFERENCES PSIM.PS_EDIT_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_EDIT
  DROP CONSTRAINT PSEDI_PSPERTRA_FK;


ALTER TABLE PSIM.PS_EDIT ADD (
  CONSTRAINT PSEDI_PSPERTRA_FK 
  FOREIGN KEY (PRIMARY_TRAIT_EDIT_ID) 
  REFERENCES PSIM.PS_PERSON_TRAIT (PS_PERSON_TRAIT_ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_FILE_BASED_ENUM
  DROP CONSTRAINT PSFILBASEN_PK;

ALTER TABLE PSIM.PS_FILE_BASED_ENUM ADD (
  CONSTRAINT PSFILBASEN_PK
  PRIMARY KEY
  (PS_FILE_BASED_ENUM_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY
  DROP CONSTRAINT PSPERADDH_PK;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY ADD (
  CONSTRAINT PSPERADDH_PK
  PRIMARY KEY
  (PS_PERSON_ADDRESS_HISTORY_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY
  DROP CONSTRAINT PSPERADDH_PSCHGTYP_FK;


ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY ADD (
  CONSTRAINT PSPERADDH_PSCHGTYP_FK 
  FOREIGN KEY (CHANGE_TYPE_ID) 
  REFERENCES PSIM.PS_CHANGE_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY
  DROP CONSTRAINT PSPERADDH_PSPERADDR_FK;


ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY ADD (
  CONSTRAINT PSPERADDH_PSPERADDR_FK 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES PSIM.PS_PERSON_ADDRESS (PS_PERSON_ADDRESS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY
  DROP CONSTRAINT PSPERADDH_PSVER_FK;


ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY ADD (
  CONSTRAINT PSPERADDH_PSVER_FK 
  FOREIGN KEY (VERIFICATION_ID) 
  REFERENCES PSIM.PS_VERIFICATION (PS_VERIFICATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_ADDRESS
  DROP CONSTRAINT PSPERADDR_PK;

ALTER TABLE PSIM.PS_PERSON_ADDRESS ADD (
  CONSTRAINT PSPERADDR_PK
  PRIMARY KEY
  (PS_PERSON_ADDRESS_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_ADDRESS
  DROP CONSTRAINT PSPERADDR_PSPERTRA_FK;


ALTER TABLE PSIM.PS_PERSON_ADDRESS ADD (
  CONSTRAINT PSPERADDR_PSPERTRA_FK 
  FOREIGN KEY (PS_PERSON_TRAIT_ID) 
  REFERENCES PSIM.PS_PERSON_TRAIT (PS_PERSON_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK
  DROP CONSTRAINT PSPERALIA_PK;

ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK ADD (
  CONSTRAINT PSPERALIA_PK
  PRIMARY KEY
  (PS_PERSON_ALIAS_LINK_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK
  DROP CONSTRAINT PSPERALIA_PSPERNAMHI_FK;


ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK ADD (
  CONSTRAINT PSPERALIA_PSPERNAMHI_FK 
  FOREIGN KEY (PERSON_NAME_HISTORY_ID) 
  REFERENCES PSIM.PS_PERSON_NAME_HISTORY (PS_PERSON_NAME_HISTORY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK
  DROP CONSTRAINT PSPERALIA_PSSSNHIST_FK;


ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK ADD (
  CONSTRAINT PSPERALIA_PSSSNHIST_FK 
  FOREIGN KEY (PS_SSN_HISTORY_ID) 
  REFERENCES PSIM.PS_SSN_HISTORY (PS_SSN_HISTORY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_CORRELATION
  DROP CONSTRAINT PSPERCOR_PK;

ALTER TABLE PSIM.PS_PERSON_CORRELATION ADD (
  CONSTRAINT PSPERCOR_PK
  PRIMARY KEY
  (PS_PERSON_CORRELATION_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_CORRELATION
  DROP CONSTRAINT PSPERCOR_PSPERCOR_FK;


ALTER TABLE PSIM.PS_PERSON_CORRELATION ADD (
  CONSTRAINT PSPERCOR_PSPERCOR_FK 
  FOREIGN KEY (SURVIVING_CORRELATION_ID) 
  REFERENCES PSIM.PS_PERSON_CORRELATION (PS_PERSON_CORRELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_CORRELATION
  DROP CONSTRAINT PSPERCOR_PSPERTRA_FK;


ALTER TABLE PSIM.PS_PERSON_CORRELATION ADD (
  CONSTRAINT PSPERCOR_PSPERTRA_FK 
  FOREIGN KEY (PERSONTRAIT_ID) 
  REFERENCES PSIM.PS_PERSON_TRAIT (PS_PERSON_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_CORRELATION
  DROP CONSTRAINT PSPERCOR_PSPERVPI_FK;


ALTER TABLE PSIM.PS_PERSON_CORRELATION ADD (
  CONSTRAINT PSPERCOR_PSPERVPI_FK 
  FOREIGN KEY (PERSON_VPID_ID) 
  REFERENCES PSIM.PS_PERSON_VPID (PS_PERSONVPID_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_CORRELATION
  DROP CONSTRAINT PSPERCOR_PSSYSOFINT_FK;


ALTER TABLE PSIM.PS_PERSON_CORRELATION ADD (
  CONSTRAINT PSPERCOR_PSSYSOFINT_FK 
  FOREIGN KEY (SYSTEM_OF_INTEREST_TYPE_ID) 
  REFERENCES PSIM.PS_SYSTEM_OF_INTEREST_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY
  DROP CONSTRAINT PSPERNAMHI_PK;

ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY ADD (
  CONSTRAINT PSPERNAMHI_PK
  PRIMARY KEY
  (PS_PERSON_NAME_HISTORY_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY
  DROP CONSTRAINT PSPERNAMHI_PSCHGTYP_FK;


ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY ADD (
  CONSTRAINT PSPERNAMHI_PSCHGTYP_FK 
  FOREIGN KEY (CHANGE_TYPE_ID) 
  REFERENCES PSIM.PS_CHANGE_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY
  DROP CONSTRAINT PSPERNAMHI_PSPERNAM_FK;


ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY ADD (
  CONSTRAINT PSPERNAMHI_PSPERNAM_FK 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES PSIM.PS_PERSON_NAME (PS_PERSON_NAME_ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY
  DROP CONSTRAINT PSPERNAMHI_PSVER_FK;


ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY ADD (
  CONSTRAINT PSPERNAMHI_PSVER_FK 
  FOREIGN KEY (VERIFICATION_ID) 
  REFERENCES PSIM.PS_VERIFICATION (PS_VERIFICATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_NAME
  DROP CONSTRAINT PSPERNAM_PK;

ALTER TABLE PSIM.PS_PERSON_NAME ADD (
  CONSTRAINT PSPERNAM_PK
  PRIMARY KEY
  (PS_PERSON_NAME_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_NAME
  DROP CONSTRAINT PSPERNAM_PSPERTRA_FK;


ALTER TABLE PSIM.PS_PERSON_NAME ADD (
  CONSTRAINT PSPERNAM_PSPERTRA_FK 
  FOREIGN KEY (PERSON_TRAIT_ID) 
  REFERENCES PSIM.PS_PERSON_TRAIT (PS_PERSON_TRAIT_ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY
  DROP CONSTRAINT PSPERNPIHI_PK;

ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY ADD (
  CONSTRAINT PSPERNPIHI_PK
  PRIMARY KEY
  (PS_PERSON_NPI_HISTORY_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY
  DROP CONSTRAINT PSPERNPIHI_PSPERNPI_FK;


ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY ADD (
  CONSTRAINT PSPERNPIHI_PSPERNPI_FK 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES PSIM.PS_PERSON_NPI (PS_PERSON_NPI_ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_NPI
  DROP CONSTRAINT PSPERNPI_PK;

ALTER TABLE PSIM.PS_PERSON_NPI ADD (
  CONSTRAINT PSPERNPI_PK
  PRIMARY KEY
  (PS_PERSON_NPI_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_NPI
  DROP CONSTRAINT PSPERNPI_PSPERTRA_FK;


ALTER TABLE PSIM.PS_PERSON_NPI ADD (
  CONSTRAINT PSPERNPI_PSPERTRA_FK 
  FOREIGN KEY (PS_PERSON_TRAIT_ID) 
  REFERENCES PSIM.PS_PERSON_TRAIT (PS_PERSON_TRAIT_ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY
  DROP CONSTRAINT PSPERPHNHI_PK;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY ADD (
  CONSTRAINT PSPERPHNHI_PK
  PRIMARY KEY
  (PS_PERSON_PHONE_HISTORY_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY
  DROP CONSTRAINT PSPERPHNHI_PSCHGTYP_FK;


ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY ADD (
  CONSTRAINT PSPERPHNHI_PSCHGTYP_FK 
  FOREIGN KEY (CHANGE_TYPE_ID) 
  REFERENCES PSIM.PS_CHANGE_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY
  DROP CONSTRAINT PSPERPHNHI_PSPERPHN_FK;


ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY ADD (
  CONSTRAINT PSPERPHNHI_PSPERPHN_FK 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES PSIM.PS_PERSON_PHONE (PS_PERSON_PHONE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY
  DROP CONSTRAINT PSPERPHNHI_PSVER_FK;


ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY ADD (
  CONSTRAINT PSPERPHNHI_PSVER_FK 
  FOREIGN KEY (VERIFICATION_ID) 
  REFERENCES PSIM.PS_VERIFICATION (PS_VERIFICATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_PHONE
  DROP CONSTRAINT PSPERPHN_PK;

ALTER TABLE PSIM.PS_PERSON_PHONE ADD (
  CONSTRAINT PSPERPHN_PK
  PRIMARY KEY
  (PS_PERSON_PHONE_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_PHONE
  DROP CONSTRAINT PSPERPHN_PSPERTRA_FK;


ALTER TABLE PSIM.PS_PERSON_PHONE ADD (
  CONSTRAINT PSPERPHN_PSPERTRA_FK 
  FOREIGN KEY (PS_PERSON_TRAIT_ID) 
  REFERENCES PSIM.PS_PERSON_TRAIT (PS_PERSON_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY
  DROP CONSTRAINT PSPERTRAHI_PK;

ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY ADD (
  CONSTRAINT PSPERTRAHI_PK
  PRIMARY KEY
  (PS_PERSONTRAIT_HISTORY_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY
  DROP CONSTRAINT PSPERTRAHI_PSCHGTYP_FK;


ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY ADD (
  CONSTRAINT PSPERTRAHI_PSCHGTYP_FK 
  FOREIGN KEY (CHANGETYPE_ID) 
  REFERENCES PSIM.PS_CHANGE_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY
  DROP CONSTRAINT PSPERTRAHI_PSEDI_FK;


ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY ADD (
  CONSTRAINT PSPERTRAHI_PSEDI_FK 
  FOREIGN KEY (EDIT_ID) 
  REFERENCES PSIM.PS_EDIT (PS_EDIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY
  DROP CONSTRAINT PSPERTRAHI_PSPERTRA_FK;


ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY ADD (
  CONSTRAINT PSPERTRAHI_PSPERTRA_FK 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES PSIM.PS_PERSON_TRAIT (PS_PERSON_TRAIT_ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY
  DROP CONSTRAINT PSPERTRAHI_PSVER_FK;


ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY ADD (
  CONSTRAINT PSPERTRAHI_PSVER_FK 
  FOREIGN KEY (VERIFICATION_ID) 
  REFERENCES PSIM.PS_VERIFICATION (PS_VERIFICATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_TRAIT
  DROP CONSTRAINT PSPERTRA_PK;

ALTER TABLE PSIM.PS_PERSON_TRAIT ADD (
  CONSTRAINT PSPERTRA_PK
  PRIMARY KEY
  (PS_PERSON_TRAIT_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_VPID
  DROP CONSTRAINT PSPERVPI_PK;

ALTER TABLE PSIM.PS_PERSON_VPID ADD (
  CONSTRAINT PSPERVPI_PK
  PRIMARY KEY
  (PS_PERSONVPID_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_VPID
  DROP CONSTRAINT PSPERVPI_PSPERTRA_FK;


ALTER TABLE PSIM.PS_PERSON_VPID ADD (
  CONSTRAINT PSPERVPI_PSPERTRA_FK 
  FOREIGN KEY (PRIMARY_TRAIT_ID) 
  REFERENCES PSIM.PS_PERSON_TRAIT (PS_PERSON_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_VPID
  DROP CONSTRAINT PSPERVPI_PSPERVPI_FK;


ALTER TABLE PSIM.PS_PERSON_VPID ADD (
  CONSTRAINT PSPERVPI_PSPERVPI_FK 
  FOREIGN KEY (SURVIVING_VPID_ID) 
  REFERENCES PSIM.PS_PERSON_VPID (PS_PERSONVPID_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_VPID
  DROP CONSTRAINT PSPERVPI_PSSYSOFINT_FK;


ALTER TABLE PSIM.PS_PERSON_VPID ADD (
  CONSTRAINT PSPERVPI_PSSYSOFINT_FK 
  FOREIGN KEY (ORIGINAL_FACILITY_ID) 
  REFERENCES PSIM.PS_SYSTEM_OF_INTEREST_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_PERSON_VPID
  DROP CONSTRAINT PSPERVPI_U_VPIDVALUE_UK;

ALTER TABLE PSIM.PS_PERSON_VPID ADD (
  CONSTRAINT PSPERVPI_U_VPIDVALUE_UK
  UNIQUE (VPID_VALUE)
  ENABLE VALIDATE);
ALTER TABLE PSIM.QUEUE
  DROP CONSTRAINT PSQUE_PK;

ALTER TABLE PSIM.QUEUE ADD (
  CONSTRAINT PSQUE_PK
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_SSN_HISTORY
  DROP CONSTRAINT PSSSNHIST_PK;

ALTER TABLE PSIM.PS_SSN_HISTORY ADD (
  CONSTRAINT PSSSNHIST_PK
  PRIMARY KEY
  (PS_SSN_HISTORY_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_SSN_HISTORY
  DROP CONSTRAINT PSSSNHIST_PSSSN_FK;


ALTER TABLE PSIM.PS_SSN_HISTORY ADD (
  CONSTRAINT PSSSNHIST_PSSSN_FK 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES PSIM.PS_SSN (PS_SSN_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_SSN
  DROP CONSTRAINT PSSSN_PK;

ALTER TABLE PSIM.PS_SSN ADD (
  CONSTRAINT PSSSN_PK
  PRIMARY KEY
  (PS_SSN_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_SSN
  DROP CONSTRAINT PSSSN_PSPERTRA_FK;


ALTER TABLE PSIM.PS_SSN ADD (
  CONSTRAINT PSSSN_PSPERTRA_FK 
  FOREIGN KEY (PERSON_TRAIT_ID) 
  REFERENCES PSIM.PS_PERSON_TRAIT (PS_PERSON_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE
  DROP CONSTRAINT PSSYSOFINT_NAME_UK;

ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE ADD (
  CONSTRAINT PSSYSOFINT_NAME_UK
  UNIQUE (NAME)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE
  DROP CONSTRAINT PSSYSOFINT_PK;

ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE ADD (
  CONSTRAINT PSSYSOFINT_PK
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE
  DROP CONSTRAINT PSVERLEV_LEVODR_UK;

ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE ADD (
  CONSTRAINT PSVERLEV_LEVODR_UK
  UNIQUE (LEVEL_ORDER_NUMBER)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE
  DROP CONSTRAINT PSVERLEV_NAME_UK;

ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE ADD (
  CONSTRAINT PSVERLEV_NAME_UK
  UNIQUE (NAME)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE
  DROP CONSTRAINT PSVERLEV_PK;

ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE ADD (
  CONSTRAINT PSVERLEV_PK
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_VERIFICATION
  DROP CONSTRAINT PSVER_PK;

ALTER TABLE PSIM.PS_VERIFICATION ADD (
  CONSTRAINT PSVER_PK
  PRIMARY KEY
  (PS_VERIFICATION_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_VERIFICATION
  DROP CONSTRAINT PSVER_PSVERLEV_FK;


ALTER TABLE PSIM.PS_VERIFICATION ADD (
  CONSTRAINT PSVER_PSVERLEV_FK 
  FOREIGN KEY (VERIFICATION_LEVEL_ID) 
  REFERENCES PSIM.PS_VERIFICATION_LEVEL_TYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE
  DROP CONSTRAINT PSVIRTAB_JAVNAME_UK;

ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE ADD (
  CONSTRAINT PSVIRTAB_JAVNAME_UK
  UNIQUE (JAVA_NAME)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE
  DROP CONSTRAINT PSVIRTAB_PK;

ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE ADD (
  CONSTRAINT PSVIRTAB_PK
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE
  DROP CONSTRAINT PSVIRTAB_VISNAME_UK;

ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE ADD (
  CONSTRAINT PSVIRTAB_VISNAME_UK
  UNIQUE (VISTA_NAME)
  ENABLE VALIDATE);
ALTER TABLE PSIM.QUEUE
  DROP CONSTRAINT QUE_NAME_UK;

ALTER TABLE PSIM.QUEUE ADD (
  CONSTRAINT QUE_NAME_UK
  UNIQUE (NAME)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IDM_NOTE_REF
  DROP CONSTRAINT RELATIONSHIP18;


ALTER TABLE PSIM.IDM_NOTE_REF ADD (
  CONSTRAINT RELATIONSHIP18 
  FOREIGN KEY (IDM_NOTIFICATION_ID) 
  REFERENCES PSIM.IDM_NOTIFICATION (IDM_NOTIFICATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT
  DROP CONSTRAINT RELATIONSHIP19;


ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT ADD (
  CONSTRAINT RELATIONSHIP19 
  FOREIGN KEY (IMDQ_EXCEPTION_ID) 
  REFERENCES PSIM.IMDQ_EXCEPTION (IMDQ_EXCEPTION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PSIM.RPT_PSIM_TRAITS
  DROP CONSTRAINT RPTPSIMT_PK;

ALTER TABLE PSIM.RPT_PSIM_TRAITS ADD (
  CONSTRAINT RPTPSIMT_PK
  PRIMARY KEY
  (VPID_ID)
  ENABLE VALIDATE);
ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  IDM_NOTIFICATION_ID NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  IDM_NOTIFICATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  TYPE NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  TYPE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  NOTE NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  NOTE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  SOURCE NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  SOURCE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  STATUS NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  STATUS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  IDM_NOTE_ID NULL;

ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  IDM_NOTE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  IDM_NOTIFICATION_ID NULL;

ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  IDM_NOTIFICATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  TYPE NULL;

ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  TYPE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  LINK_ID NULL;

ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  LINK_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  STATUS NULL;

ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  STATUS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IDM_NOTE_REF MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  IDM_NOTIFICATION_GROUP_ID NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  IDM_NOTIFICATION_GROUP_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  NAME NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  DESCRIPTION NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  DESCRIPTION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  CODE NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  STATUS NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  STATUS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IDM_NOTIFICATION_GROUP MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  IDM_STATION_MAP_ID NULL;

ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  IDM_STATION_MAP_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  STATION_NUMBER NULL;

ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  STATION_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  STATION_NAME NULL;

ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  STATION_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IDM_STATION_MAP MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  IMDQ_EXCEPTION_TRAIT_ID NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  IMDQ_EXCEPTION_TRAIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  IMDQ_EXCEPTION_ID NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  IMDQ_EXCEPTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  INTERNAL_IDENTIFIER NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TRAIT MODIFY 
  INTERNAL_IDENTIFIER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  PS_MESSAGE_LOG_ID NULL;

ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  PS_MESSAGE_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  MESSAGE_NUMBER NULL;

ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  MESSAGE_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  MESSAGE_DIRECTION_CODE NULL;

ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  MESSAGE_DIRECTION_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_MESSAGE_LOG MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  IDM_MESSAGE_LOG_ID NULL;

ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  IDM_MESSAGE_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  MESSAGE_NUMBER NULL;

ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  MESSAGE_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  MESSAGE_DIRECTION_CODE NULL;

ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  MESSAGE_DIRECTION_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IDM_MESSAGE_LOG MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  IMDQ_EXCEPTION_ID NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  IMDQ_EXCEPTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  IMDQ_EXCEPTION_TYPE_ID NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  IMDQ_EXCEPTION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  STD_IDEVENTTYPE_ID NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  STD_IDEVENTTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  STD_IDENTIFIERTYPE_ID NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  STD_IDENTIFIERTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  PSSYSOFINT_ID NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION MODIFY 
  PSSYSOFINT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  ID NULL;

ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  JAVA_NAME NULL;

ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  JAVA_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  VISTA_NAME NULL;

ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  VISTA_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  VISTA_TYPE_CODE NULL;

ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  VISTA_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  MAX_LENGTH_TOTAL NULL;

ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  MAX_LENGTH_TOTAL NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_VIRTUAL_TABLE_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE MODIFY 
  ID NULL;

ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE MODIFY 
  NAME NULL;

ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_SYSTEM_OF_INTEREST_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE MODIFY 
  ID NULL;

ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE MODIFY 
  NAME NULL;

ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_DUPE_RESOLUTION_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI MODIFY 
  PS_PERSON_NPI_ID NULL;

ALTER TABLE PSIM.PS_PERSON_NPI MODIFY 
  PS_PERSON_NPI_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI MODIFY 
  PS_PERSON_TRAIT_ID NULL;

ALTER TABLE PSIM.PS_PERSON_NPI MODIFY 
  PS_PERSON_TRAIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_NPI MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_NPI MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_NPI MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  PS_PERSON_NAME_HISTORY_ID NULL;

ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  PS_PERSON_NAME_HISTORY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  OWNER_ID NULL;

ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  OWNER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  NAME_TYPE_ID NULL;

ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  NAME_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  CHANGE_TYPE_ID NULL;

ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  CHANGE_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  EFFECTIVE_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  EFFECTIVE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  EXPIRATION_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  EXPIRATION_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_NAME_HISTORY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT_TYPE MODIFY 
  ID NULL;

ALTER TABLE PSIM.PS_EDIT_TYPE MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT_TYPE MODIFY 
  NAME NULL;

ALTER TABLE PSIM.PS_EDIT_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_EDIT_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_EDIT_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_EDIT_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  PS_PERSONVPID_ID NULL;

ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  PS_PERSONVPID_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  VPID_VALUE NULL;

ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  VPID_VALUE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  IDENTITY_UPDATE_EVENT_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  IDENTITY_UPDATE_EVENT_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  IDENTITY_TRANSACTION_TYPE NULL;

ALTER TABLE PSIM.PS_PERSON_VPID MODIFY 
  IDENTITY_TRANSACTION_TYPE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.RPT_PSIM_TRAITS MODIFY 
  VPID_ID NULL;

ALTER TABLE PSIM.RPT_PSIM_TRAITS MODIFY 
  VPID_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.RPT_PSIM_TRAITS MODIFY 
  VPID_VALUE NULL;

ALTER TABLE PSIM.RPT_PSIM_TRAITS MODIFY 
  VPID_VALUE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.RPT_PSIM_TRAITS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.RPT_PSIM_TRAITS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.RPT_PSIM_TRAITS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.RPT_PSIM_TRAITS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN MODIFY 
  PS_SSN_ID NULL;

ALTER TABLE PSIM.PS_SSN MODIFY 
  PS_SSN_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN MODIFY 
  PERSON_TRAIT_ID NULL;

ALTER TABLE PSIM.PS_SSN MODIFY 
  PERSON_TRAIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_SSN MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_SSN MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_SSN MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  PS_VERIFICATION_ID NULL;

ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  PS_VERIFICATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  STATUS_IND NULL;

ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  STATUS_IND NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  VERIFICATION_LEVEL_ID NULL;

ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  VERIFICATION_LEVEL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_VERIFICATION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  ID NULL;

ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  NAME NULL;

ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  LEVEL_ORDER_NUMBER NULL;

ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  LEVEL_ORDER_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_VERIFICATION_LEVEL_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  IMDQ_TASK_VPIDS_ID NULL;

ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  IMDQ_TASK_VPIDS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  VPID NULL;

ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  VPID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  IMDQ_TASK_ID NULL;

ALTER TABLE PSIM.IMDQ_TASK_VPIDS MODIFY 
  IMDQ_TASK_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  PS_PERSON_CORRELATION_ID NULL;

ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  PS_PERSON_CORRELATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  PERSON_VPID_ID NULL;

ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  PERSON_VPID_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  SYSTEM_OF_INTEREST_TYPE_ID NULL;

ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  SYSTEM_OF_INTEREST_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  IDENTIFIER_TYPE_ID NULL;

ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  IDENTIFIER_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  EXTERNAL_FLAG NULL;

ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  EXTERNAL_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  STATUS_IND NULL;

ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  STATUS_IND NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_CORRELATION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CHANGE_TYPE MODIFY 
  ID NULL;

ALTER TABLE PSIM.PS_CHANGE_TYPE MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CHANGE_TYPE MODIFY 
  NAME NULL;

ALTER TABLE PSIM.PS_CHANGE_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CHANGE_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_CHANGE_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CHANGE_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_CHANGE_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CHANGE_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_CHANGE_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  PS_DUPE_POTENTIAL_ID NULL;

ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  PS_DUPE_POTENTIAL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  NAME_TEXT NULL;

ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  NAME_TEXT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  PERSON_VPID1_ID NULL;

ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  PERSON_VPID1_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  PERSON_VPID2_ID NULL;

ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  PERSON_VPID2_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  DUPE_REASON_ID NULL;

ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  DUPE_REASON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_DUPE_POTENTIAL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.EVENT MODIFY 
  ID NULL;

ALTER TABLE PSIM.EVENT MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.EVENT MODIFY 
  ISPENDING NULL;

ALTER TABLE PSIM.EVENT MODIFY 
  ISPENDING NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.EVENT MODIFY 
  QUEUE_ID NULL;

ALTER TABLE PSIM.EVENT MODIFY 
  QUEUE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.EVENT MODIFY 
  VERSION NULL;

ALTER TABLE PSIM.EVENT MODIFY 
  VERSION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.EVENT MODIFY 
  CREATED NULL;

ALTER TABLE PSIM.EVENT MODIFY 
  CREATED NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.EVENT MODIFY 
  CREATEDBY NULL;

ALTER TABLE PSIM.EVENT MODIFY 
  CREATEDBY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.EVENT MODIFY 
  DATA NULL;

ALTER TABLE PSIM.EVENT MODIFY 
  DATA NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  PS_SSN_HISTORY_ID NULL;

ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  PS_SSN_HISTORY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  OWNER_ID NULL;

ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  OWNER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  STD_SSNTYPE_ID NULL;

ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  STD_SSNTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  EFFECTIVE_DATE NULL;

ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  EFFECTIVE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  EXPIRATION_DATE NULL;

ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  EXPIRATION_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_SSN_HISTORY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_FILE_BASED_ENUM MODIFY 
  PS_FILE_BASED_ENUM_ID NULL;

ALTER TABLE PSIM.PS_FILE_BASED_ENUM MODIFY 
  PS_FILE_BASED_ENUM_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_FILE_BASED_ENUM MODIFY 
  IEN_TEXT NULL;

ALTER TABLE PSIM.PS_FILE_BASED_ENUM MODIFY 
  IEN_TEXT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_FILE_BASED_ENUM MODIFY 
  LAST_NAME NULL;

ALTER TABLE PSIM.PS_FILE_BASED_ENUM MODIFY 
  LAST_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  IMDQ_TASK_NOTES_ID NULL;

ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  IMDQ_TASK_NOTES_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  TEXT1 NULL;

ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  TEXT1 NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  IMDQ_TASK_ID NULL;

ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  IMDQ_TASK_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  IMDQ_TEAM_MEMBER_ID NULL;

ALTER TABLE PSIM.IMDQ_TASK_NOTES MODIFY 
  IMDQ_TEAM_MEMBER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME MODIFY 
  PS_PERSON_NAME_ID NULL;

ALTER TABLE PSIM.PS_PERSON_NAME MODIFY 
  PS_PERSON_NAME_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME MODIFY 
  PERSON_TRAIT_ID NULL;

ALTER TABLE PSIM.PS_PERSON_NAME MODIFY 
  PERSON_TRAIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_NAME MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_NAME MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NAME MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_NAME MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.ADR_PROCESS_LOG MODIFY 
  ADR_PROCESS_LOG_ID NULL;

ALTER TABLE PSIM.ADR_PROCESS_LOG MODIFY 
  ADR_PROCESS_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.ADR_ERROR_MESSAGES MODIFY 
  ADR_ERROR_MESSAGE_ID NULL;

ALTER TABLE PSIM.ADR_ERROR_MESSAGES MODIFY 
  ADR_ERROR_MESSAGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  PS_CORRELATION_CATEGORY_ID NULL;

ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  PS_CORRELATION_CATEGORY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  NAME_TEXT NULL;

ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  NAME_TEXT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  CORRELATION_ID NULL;

ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  CORRELATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  CATEGORY_ID NULL;

ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  CATEGORY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_CORRELATION_CATEGORY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT MODIFY 
  PS_EDIT_ID NULL;

ALTER TABLE PSIM.PS_EDIT MODIFY 
  PS_EDIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT MODIFY 
  STATUS_DESCRIPTION NULL;

ALTER TABLE PSIM.PS_EDIT MODIFY 
  STATUS_DESCRIPTION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT MODIFY 
  EXCEPTIONS_TEXT NULL;

ALTER TABLE PSIM.PS_EDIT MODIFY 
  EXCEPTIONS_TEXT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT MODIFY 
  EDIT_TYPE_ID NULL;

ALTER TABLE PSIM.PS_EDIT MODIFY 
  EDIT_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT MODIFY 
  PRIMARY_TRAIT_EDIT_ID NULL;

ALTER TABLE PSIM.PS_EDIT MODIFY 
  PRIMARY_TRAIT_EDIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT MODIFY 
  NAME_TEXT NULL;

ALTER TABLE PSIM.PS_EDIT MODIFY 
  NAME_TEXT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_EDIT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_EDIT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_EDIT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_EDIT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  IMDQ_EXCEPTION_TYPE_ID NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  IMDQ_EXCEPTION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  CODE NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  NAME NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  STD_IDEXCEPTYPEGROUP_ID NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_TYPE MODIFY 
  STD_IDEXCEPTYPEGROUP_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  IMDQ_TASK_SOI_ID NULL;

ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  IMDQ_TASK_SOI_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  PSSYSOFINT_ID NULL;

ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  PSSYSOFINT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  IMDQ_TASK_ID NULL;

ALTER TABLE PSIM.IMDQ_TASK_SOI MODIFY 
  IMDQ_TASK_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK MODIFY 
  IMDQ_TASK_ID NULL;

ALTER TABLE PSIM.IMDQ_TASK MODIFY 
  IMDQ_TASK_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK MODIFY 
  TRACKING_NUMBER NULL;

ALTER TABLE PSIM.IMDQ_TASK MODIFY 
  TRACKING_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_TASK MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_TASK MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_TASK MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  IMDQ_ROLE_ID NULL;

ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  IMDQ_ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  CODE NULL;

ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  NAME NULL;

ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_ROLE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  PS_PERSON_NPI_HISTORY_ID NULL;

ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  PS_PERSON_NPI_HISTORY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  OWNER_ID NULL;

ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  OWNER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  IS_ACTIVE NULL;

ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  IS_ACTIVE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  EFFECTIVE_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  EFFECTIVE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  EXPIRATION_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_NPI_HISTORY MODIFY 
  EXPIRATION_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  IMDQ_TEAM_MEMBER_ID NULL;

ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  IMDQ_TEAM_MEMBER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  VPID NULL;

ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  VPID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  NAME NULL;

ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  VA_DOMAIN_LOGIN NULL;

ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  VA_DOMAIN_LOGIN NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_TEAM_MEMBER MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT MODIFY 
  PS_PERSON_TRAIT_ID NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT MODIFY 
  PS_PERSON_TRAIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  PS_PERSON_ALIAS_LINK_ID NULL;

ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  PS_PERSON_ALIAS_LINK_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  PERSON_NAME_HISTORY_ID NULL;

ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  PERSON_NAME_HISTORY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  PS_SSN_HISTORY_ID NULL;

ALTER TABLE PSIM.PS_PERSON_ALIAS_LINK MODIFY 
  PS_SSN_HISTORY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  PS_PERSONTRAIT_HISTORY_ID NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  PS_PERSONTRAIT_HISTORY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  OWNER_ID NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  OWNER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  CHANGETYPE_ID NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  CHANGETYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  NAME_TEXT NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  NAME_TEXT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  EFFECTIVE_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  EFFECTIVE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  EXPIRATION_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  EXPIRATION_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_TRAIT_HISTORY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_REASON_TYPE MODIFY 
  ID NULL;

ALTER TABLE PSIM.PS_DUPE_REASON_TYPE MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_REASON_TYPE MODIFY 
  NAME NULL;

ALTER TABLE PSIM.PS_DUPE_REASON_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_REASON_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_DUPE_REASON_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_REASON_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_DUPE_REASON_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_DUPE_REASON_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_DUPE_REASON_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.QUEUE MODIFY 
  ID NULL;

ALTER TABLE PSIM.QUEUE MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.QUEUE MODIFY 
  NAME NULL;

ALTER TABLE PSIM.QUEUE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.QUEUE MODIFY 
  VERSION NULL;

ALTER TABLE PSIM.QUEUE MODIFY 
  VERSION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.QUEUE MODIFY 
  CREATEDBY NULL;

ALTER TABLE PSIM.QUEUE MODIFY 
  CREATEDBY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.QUEUE MODIFY 
  CREATED NULL;

ALTER TABLE PSIM.QUEUE MODIFY 
  CREATED NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_ADT_EVENT MODIFY 
  PS_ADT_EVENT_ID NULL;

ALTER TABLE PSIM.PS_ADT_EVENT MODIFY 
  PS_ADT_EVENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_ADT_EVENT MODIFY 
  RECEIVED_DATE NULL;

ALTER TABLE PSIM.PS_ADT_EVENT MODIFY 
  RECEIVED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_ADT_EVENT MODIFY 
  DATA NULL;

ALTER TABLE PSIM.PS_ADT_EVENT MODIFY 
  DATA NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  IMDQ_TEAM_MEMBER_ID NULL;

ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  IMDQ_TEAM_MEMBER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  IMDQ_MEM_ROLE_REF_ID NULL;

ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  IMDQ_MEM_ROLE_REF_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  IMDQ_ROLE_ID NULL;

ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  IMDQ_ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_MEM_ROLE_REF MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  IMDQ_TASK_H_ID NULL;

ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  IMDQ_TASK_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  IMDQ_TASK_ID NULL;

ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  IMDQ_TASK_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  TRACKING_NUMBER NULL;

ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  TRACKING_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_TASK_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  PS_PERSON_PHONE_HISTORY_ID NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  PS_PERSON_PHONE_HISTORY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  OWNER_ID NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  OWNER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  PHONE_CONTACT_TYPE_ID NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  PHONE_CONTACT_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  CHANGE_TYPE_ID NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  CHANGE_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  EFFECTIVE_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  EFFECTIVE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  EXPIRATION_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  EXPIRATION_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  PS_PERSON_ADDRESS_HISTORY_ID NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  PS_PERSON_ADDRESS_HISTORY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  OWNER_ID NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  OWNER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  ADDRESS_TYPE_ID NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  ADDRESS_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  CHANGE_TYPE_ID NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  CHANGE_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  IS_ACTIVE_FLAG NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  IS_ACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  EFFECTIVE_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  EFFECTIVE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  EXPIRATION_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  EXPIRATION_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS_HISTORY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  PS_PERSON_PHONE_ID NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  PS_PERSON_PHONE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  PS_PERSON_TRAIT_ID NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  PS_PERSON_TRAIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_PHONE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  PS_PERSON_ADDRESS_ID NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  PS_PERSON_ADDRESS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  PS_PERSON_TRAIT_ID NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  PS_PERSON_TRAIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.PS_PERSON_ADDRESS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  IMDQ_EXCEPTION_IDS_ID NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  IMDQ_EXCEPTION_IDS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  INTERNAL_IDENTIFIER NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  INTERNAL_IDENTIFIER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  IMDQ_EXCEPTION_ID NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  IMDQ_EXCEPTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_EXCEPTION_IDS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_ACTION_ID NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_ACTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_EXCEPTION_ID NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_EXCEPTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_ACTION_REF_ID NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_ACTION_REF_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_TEAM_MEMBER_ID NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_TEAM_MEMBER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_EXCEPTION_IDS_ID1 NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_EXCEPTION_IDS_ID1 NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_EXCEPTION_IDS_ID2 NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  IMDQ_EXCEPTION_IDS_ID2 NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_ACTION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  IMDQ_MEMBER_SITES_ID NULL;

ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  IMDQ_MEMBER_SITES_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  IMDQ_TEAM_MEMBER_ID NULL;

ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  IMDQ_TEAM_MEMBER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  ALLOWABLE_ACTION_ID NULL;

ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  ALLOWABLE_ACTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  SITE_ID NULL;

ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  SITE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_MEMBER_SITES MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  IMDQ_ACTION_REF_ID NULL;

ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  IMDQ_ACTION_REF_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  ACTION_NAME NULL;

ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  ACTION_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  ACTION_TYPE NULL;

ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  ACTION_TYPE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  ACTION_DESC NULL;

ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  ACTION_DESC NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE PSIM.IMDQ_ACTION_REF MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
